# Unit JSON Schema

Units are game entities that exist on the board. They may be summoned by cards or exist independently.

## File Naming Convention
- `unit_{karma}_{number}.json` - Card-associated units
- `standalone_{name}.json` - Units not tied to cards (kings, walls, etc.)

## Schema

```json
{
  "id": "string (required) - Unique identifier",
  "name": "string (required) - Display name",
  "category": "unit | building | king (required)",
  
  "stats": {
    "hp": "int (required) - Health points",
    "speed": "int (required) - Turn order priority",
    "move": "int (required) - Movement range",
    "attackRange": "int (optional) - Attack range. 0=cannot attack, 1=melee, 2+=ranged. Default: 1",
    "visionRange": "int (optional) - How far unit can see. Default: move + 1",
    
    // DAMAGE MANIFESTS - Attack types (use these instead of legacy atk/def)
    // Format: {manifest}Atk / {manifest}Def
    // Manifests: stab, slash, crush, fire, shock, magic, poison, psychic, void
    "slashAtk": "int (optional) - Slash attack power",
    "slashDef": "int (optional) - Slash defense",
    "stabAtk": "int (optional) - Stab/pierce attack power",
    "stabDef": "int (optional) - Stab/pierce defense",
    "crushAtk": "int (optional) - Blunt attack power",
    "crushDef": "int (optional) - Blunt defense",
    "fireAtk": "int (optional) - Fire attack power",
    "fireDef": "int (optional) - Fire defense",
    "shockAtk": "int (optional) - Shock/lightning attack power",
    "shockDef": "int (optional) - Shock/lightning defense",
    "magicAtk": "int (optional) - Magic attack power",
    "magicDef": "int (optional) - Magic defense",
    "poisonAtk": "int (optional) - Poison attack power",
    "poisonDef": "int (optional) - Poison defense",
    "psychicAtk": "int (optional) - Psychic attack power",
    "psychicDef": "int (optional) - Psychic defense",
    "voidAtk": "int (optional) - Void/dark attack power",
    "voidDef": "int (optional) - Void/dark defense",
    
    // ABILITY EFFECTIVENESS - Scales ability power (+1 per point)
    // Format: {type}Effectiveness
    "fireEffectiveness": "int (optional) - Fire ability bonus",
    "iceEffectiveness": "int (optional) - Ice ability bonus",
    "shockEffectiveness": "int (optional) - Shock ability bonus",
    "healingEffectiveness": "int (optional) - Healing ability bonus",
    "summoningEffectiveness": "int (optional) - Summoning ability bonus",
    "buffingEffectiveness": "int (optional) - Buff ability bonus",
    "debuffingEffectiveness": "int (optional) - Debuff ability bonus",
    
    // LEGACY (kept for backward compatibility, avoid in new cards)
    "atk": "int (deprecated) - Use manifest ATK instead",
    "def": "int (deprecated) - Use manifest DEF instead"
  },
  
  // Which manifests this unit's basic attack uses
  "basicAttackManifests": ["slash", "fire"],
  
  "properties": {
    "blocks_movement": "bool (optional) - Default: false (true for buildings)",
    "blocks_vision": "bool (optional) - Default: false (true for walls)",
    "flying": "bool (optional) - Ignores terrain, not blocked by units",
    "aquatic": "bool (optional) - Ignores water penalties"
  },
  
  "innate_effects": [
    {
      "trigger": "string - When effect activates",
      "effect": "string - Effect type",
      "target": "string (optional) - Target specification",
      "value": "any (optional) - Effect value",
      "manifests": ["fire", "magic"], // For damage effects
      "description": "string - Human-readable description"
    }
  ],
  
  "ai_tags": {
    "role": "attacker | defender | support | control | utility | finisher",
    "priority": "int 1-10 - How important to deploy",
    "movement": "aggressive | cautious | flanking | defensive | stationary",
    "target_preference": ["king", "castle", "unit", "building", "ally_unit", "ally_king"],
    "threat_level": "int 1-10 - How dangerous when enemy plays this"
  },
  
  "description": "string (optional) - Lore/flavor description",
  "artist": "string (optional) - Art credit"
}
```

## Damage Manifest System

Inspired by Dark Souls 2's damage types. Each unit has attack and defense values for different damage types.

### Manifest Types
| Manifest | Description | Typical Weapons |
|----------|-------------|-----------------|
| `stab` | Piercing damage | Spears, daggers, arrows |
| `slash` | Cutting damage | Swords, claws, axes |
| `crush` | Blunt damage | Hammers, fists, maces |
| `fire` | Fire damage | Flames, explosions |
| `shock` | Electric/holy | Lightning, divine smite |
| `magic` | Arcane damage | Spells, wands |
| `poison` | Toxic damage | Venoms, diseases |
| `psychic` | Mind damage | Illusions, fear |
| `void` | Dark damage | Curses, entropy |

### Damage Calculation
```
For each manifest in basicAttackManifests:
    portion = attackerManifestAtk - defenderManifestDef
    portion = max(0, portion)  // Can't go negative

totalDamage = sum(all portions)
totalDamage = max(1, totalDamage)  // Always deal at least 1
```

### Example: Flame Knight
```json
{
  "stats": {
    "hp": 6,
    "speed": 3,
    "move": 2,
    "slashAtk": 4,
    "slashDef": 2,
    "fireAtk": 2,
    "fireDef": 1
  },
  "basicAttackManifests": ["slash", "fire"]
}
```

Attack vs unit with slashDef: 3, fireDef: 0:
- Slash: 4 - 3 = 1
- Fire: 2 - 0 = 2
- Total: 3 damage

### Ability Effectiveness

Effectiveness stats boost ability power. Each point adds +1 to the ability's base value.

Example: A unit with `healingEffectiveness: 2` casting a "Heal 3" ability heals for 5 instead.

## Categories

### unit
Standard mobile combat units. Can move and attack.
- Default z-index: 10
- blocks_movement: false
- blocks_vision: false

### building  
Structures like walls. Cannot move.
- Default z-index: 5
- blocks_movement: true
- blocks_vision: true (for walls)

### king
Special unit. Game ends if destroyed.
- Default z-index: 10
- Cannot be returned to hand
- Usually has lose_game on_death effect

## Relationship to Cards

Cards with `type: "unit"` reference units via `unit_id`:
```json
{
  "id": "card_white_001",
  "type": "unit",
  "unit_id": "unit_white_001",
  "cost": 2,
  ...card-specific data...
}
```

The card provides: cost, rarity, card_number, flavor_text, deck rules
The unit provides: stats, effects, combat behavior, AI tags
