-- FILE: 002_add_socket_slots.sql
-- PURPOSE: Add socket_slots column to local_decks table for storing socket card assignments
-- DATABASE: SQLite (embedded in Flutter client)
-- AI_CONTEXT: Migration adds support for 5 astral socket slots per deck.
--             Socket slots store card IDs in order (slot 0-4).

-- Migration: 002_add_socket_slots
-- Created: 2025-12-08
-- Phase: 2 (Core Game Loop)

-- ============================================================================
-- ADD SOCKET_SLOTS COLUMN TO LOCAL_DECKS
-- ============================================================================
-- Stores JSON array of socket card IDs in slot order
-- Example: ["socket_white_051", "socket_black_053", null, null, "socket_neutral_055"]

ALTER TABLE local_decks ADD COLUMN socket_slots TEXT;

-- ============================================================================
-- END OF MIGRATION 002
-- ============================================================================
